<?php

use App\Http\Controllers\AuthController;
use App\Http\Controllers\RecordController;
use App\Http\Controllers\UploadController;
use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

// Authentication routes (not protected)
Route::get('/login', [AuthController::class, 'showLogin'])->name('login');
Route::post('/login', [AuthController::class, 'login']);
Route::post('/logout', [AuthController::class, 'logout'])->name('logout');

// Protected routes
Route::middleware(['password.auth'])->group(function () {
    // Upload routes
    Route::get('/upload', [UploadController::class, 'index'])->name('upload.index');
    Route::post('/upload', [UploadController::class, 'uploadExcel'])->name('upload.store');
    Route::get('/upload/status/{id}', [UploadController::class, 'getUploadStatus'])->name('upload.status');

    // Records routes
    Route::get('/records', [RecordController::class, 'index'])->name('records.index');
    Route::get('/api/records', [RecordController::class, 'listRecords'])->name('api.records');

    // Redirect root to upload page
    Route::get('/', function () {
        return redirect()->route('upload.index');
    });
});

