<?php

return [
    /*
    |--------------------------------------------------------------------------
    | Excel Column Mapping
    |--------------------------------------------------------------------------
    |
    | Maps Arabic Excel headers to English database column names
    |
    */

    'column_mapping' => [
        'الاسم' => 'name',
        'رقم الموبايل' => 'mobile_number',
        'رقم بطاقة العضوية' => 'membership_card_number',
        'العنوان' => 'address',
        'رقم منزل' => 'house_number',
        'الحي' => 'neighborhood',
        'عنوان العمل' => 'work_address',
        'عنوان المنزل' => 'home_address',
        'المحافظة' => 'governorate',
        'شكاوى' => 'complaints',
        'ملاحظات' => 'notes',
        'تاريخ الانتهاء' => 'expiry_date',
        'نوع العضوية' => 'membership_type',
        'ساري حق' => 'valid_status',
    ],

    /*
    |--------------------------------------------------------------------------
    | Searchable Columns
    |--------------------------------------------------------------------------
    |
    | Columns that should be included in full-text search
    |
    */

    'searchable_columns' => [
        'name',
        'mobile_number',
        'membership_card_number',
        'address',
        'neighborhood',
        'governorate',
    ],

    /*
    |--------------------------------------------------------------------------
    | Filterable Columns
    |--------------------------------------------------------------------------
    |
    | Columns that can be filtered in the frontend
    |
    */

    'filterable_columns' => [
        'governorate',
        'membership_type',
        'valid_status',
        'expiry_date',
    ],

    /*
    |--------------------------------------------------------------------------
    | Date Columns
    |--------------------------------------------------------------------------
    |
    | Columns that contain dates and need special handling
    |
    */

    'date_columns' => [
        'expiry_date',
    ],

    /*
    |--------------------------------------------------------------------------
    | Chunk Size
    |--------------------------------------------------------------------------
    |
    | Number of rows to process per chunk
    |
    */

    'chunk_size' => 1000,

    /*
    |--------------------------------------------------------------------------
    | Batch Insert Size
    |--------------------------------------------------------------------------
    |
    | Number of rows to insert per batch statement
    |
    */

    'batch_insert_size' => 100,
];

