# Setup Instructions

## Quick Start Guide

### 1. Database Setup

Create a MySQL database:
```sql
CREATE DATABASE mypharmacy_excel CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;
```

### 2. Configure Environment

Edit `.env` file and set:
- Database credentials
- Admin password (ADMIN_PASSWORD)

### 3. Run Migrations

```bash
php artisan migrate
```

This will create:
- `uploaded_files` table
- `excel_records` table
- `jobs` table (for queues)
- `failed_jobs` table
- `sessions` table

### 4. Start Queue Worker

**IMPORTANT:** The queue worker must be running for Excel processing to work.

```bash
php artisan queue:work --tries=3
```

Keep this terminal window open. In production, use Supervisor to manage the queue worker.

### 5. Start Development Server

In a new terminal:
```bash
php artisan serve
```

### 6. Access Application

1. Open browser: `http://localhost:8000`
2. You'll be redirected to login page
3. Enter the password from `.env` (ADMIN_PASSWORD)
4. Default password is: `admin123`

## Testing the System

1. **Upload Test:**
   - Go to "رفع الملفات" (Upload Files)
   - Upload the provided Excel file: `قائمة العملاء.xlsx`
   - Watch the progress bar
   - Wait for processing to complete

2. **View Records:**
   - Go to "عرض البيانات" (View Data)
   - Test search functionality
   - Test filters
   - Test sorting by clicking column headers
   - Test pagination

## Production Checklist

- [ ] Set `APP_ENV=production` and `APP_DEBUG=false` in `.env`
- [ ] Hash the admin password and update `.env`
- [ ] Set up Supervisor for queue worker
- [ ] Configure proper file permissions
- [ ] Set up SSL certificate
- [ ] Configure backup strategy
- [ ] Set up monitoring/logging
- [ ] Run `php artisan config:cache`
- [ ] Run `php artisan route:cache`
- [ ] Run `php artisan view:cache`

## Troubleshooting

### Queue Worker Not Processing

1. Check if worker is running: `ps aux | grep queue:work`
2. Check logs: `tail -f storage/logs/laravel.log`
3. Restart worker: `php artisan queue:restart`

### File Upload Issues

1. Check PHP upload limits in `php.ini`:
   - `upload_max_filesize = 100M`
   - `post_max_size = 100M`
   - `max_execution_time = 300`

2. Check storage permissions:
   ```bash
   chmod -R 775 storage
   ```

### Database Connection Issues

1. Verify database credentials in `.env`
2. Test connection: `php artisan tinker` then `DB::connection()->getPdo();`
3. Check MySQL is running

### Arabic Text Issues

1. Verify database charset:
   ```sql
   SHOW CREATE DATABASE mypharmacy_excel;
   ```
   Should show `utf8mb4`

2. Check table collation:
   ```sql
   SHOW TABLE STATUS WHERE Name = 'excel_records';
   ```
   Collation should be `utf8mb4_unicode_ci`

## File Structure

```
MyPharmacyExcel/
├── app/
│   ├── Http/
│   │   ├── Controllers/
│   │   │   ├── AuthController.php
│   │   │   ├── RecordController.php
│   │   │   └── UploadController.php
│   │   └── Middleware/
│   │       └── PasswordAuthMiddleware.php
│   ├── Jobs/
│   │   └── ProcessExcelChunkJob.php
│   ├── Models/
│   │   ├── ExcelRecord.php
│   │   └── UploadedFile.php
│   └── Services/
│       └── ExcelImportService.php
├── config/
│   └── excel_columns.php
├── database/
│   └── migrations/
├── resources/
│   └── views/
│       ├── auth/
│       ├── layouts/
│       ├── records/
│       └── upload/
└── routes/
    └── web.php
```

## Support

For issues, check:
1. Laravel logs: `storage/logs/laravel.log`
2. Queue logs: Check failed_jobs table
3. PHP error logs
4. Browser console for frontend issues

