# Laravel Large Excel Upload System

A production-ready Laravel system for uploading and processing large Excel files (up to 150,000 rows) with chunked queue processing, password-only authentication, and a searchable/filterable data table.

## Features

- ✅ Upload Excel files (.xlsx, .csv) up to 150,000 rows
- ✅ Chunked processing using Laravel Queues (no timeouts)
- ✅ Password-only authentication
- ✅ Real-time upload progress tracking
- ✅ Searchable, filterable, and sortable data table
- ✅ Server-side pagination for performance
- ✅ Arabic text support (UTF-8)
- ✅ Automatic date conversion from Excel format

## Requirements

- PHP >= 8.1
- MySQL >= 5.7
- Composer
- Node.js (optional, for asset compilation)

## Installation

1. **Clone or navigate to the project directory:**
   ```bash
   cd MyPharmacyExcel
   ```

2. **Install dependencies:**
   ```bash
   composer install
   ```

3. **Copy environment file:**
   ```bash
   copy .env.example .env
   ```

4. **Generate application key:**
   ```bash
   php artisan key:generate
   ```

5. **Configure database in `.env`:**
   ```env
   DB_CONNECTION=mysql
   DB_HOST=127.0.0.1
   DB_PORT=3306
   DB_DATABASE=mypharmacy_excel
   DB_USERNAME=root
   DB_PASSWORD=your_password
   ```

6. **Set admin password in `.env`:**
   ```env
   ADMIN_PASSWORD=your_secure_password
   ```
   Note: For production, hash the password using:
   ```bash
   php artisan tinker
   >>> Hash::make('your_password');
   ```
   Then use the hashed value in `.env`.

7. **Run migrations:**
   ```bash
   php artisan migrate
   ```

8. **Create storage link (if needed):**
   ```bash
   php artisan storage:link
   ```

9. **Start the queue worker:**
   ```bash
   php artisan queue:work --tries=3
   ```
   **Important:** The queue worker must run continuously for file processing to work. Consider using a process manager like Supervisor in production.

10. **Start the development server:**
    ```bash
    php artisan serve
    ```

11. **Access the application:**
    - Open browser: `http://localhost:8000`
    - Login with the password set in `.env`

## Excel File Format

The system expects Excel files with the following Arabic column headers:

- الاسم (Name)
- رقم الموبايل (Mobile Number)
- رقم بطاقة العضوية (Membership Card Number)
- العنوان (Address)
- رقم منزل (House Number)
- الحي (Neighborhood)
- عنوان العمل (Work Address)
- عنوان المنزل (Home Address)
- المحافظة (Governorate)
- شكاوى (Complaints)
- ملاحظات (Notes)
- تاريخ الانتهاء (Expiry Date)
- نوع العضوية (Membership Type)
- ساري حق (Valid Status)

Column mapping can be customized in `config/excel_columns.php`.

## Configuration

### Excel Processing Settings

Edit `config/excel_columns.php` to customize:
- Column mapping (Arabic → English)
- Chunk size (default: 1000 rows)
- Batch insert size (default: 100 rows)
- Searchable columns
- Filterable columns

### Queue Configuration

The system uses database queues by default. To use Redis instead:

1. Install Redis server
2. Update `.env`:
   ```env
   QUEUE_CONNECTION=redis
   REDIS_HOST=127.0.0.1
   REDIS_PORT=6379
   ```

## Usage

1. **Upload Excel File:**
   - Navigate to "رفع الملفات" (Upload Files)
   - Select your Excel file (.xlsx or .csv)
   - Click "رفع الملف" (Upload File)
   - Monitor progress in real-time

2. **View Records:**
   - Navigate to "عرض البيانات" (View Data)
   - Use search to find specific records
   - Apply filters by Governorate, Membership Type, etc.
   - Click column headers to sort
   - Navigate pages using pagination controls

## Production Deployment

1. **Set environment to production:**
   ```env
   APP_ENV=production
   APP_DEBUG=false
   ```

2. **Optimize Laravel:**
   ```bash
   php artisan config:cache
   php artisan route:cache
   php artisan view:cache
   ```

3. **Set up Supervisor for queue worker:**
   Create `/etc/supervisor/conf.d/laravel-worker.conf`:
   ```ini
   [program:laravel-worker]
   process_name=%(program_name)s_%(process_num)02d
   command=php /path/to/your/project/artisan queue:work --sleep=3 --tries=3 --max-time=3600
   autostart=true
   autorestart=true
   stopasgroup=true
   killasgroup=true
   user=www-data
   numprocs=2
   redirect_stderr=true
   stdout_logfile=/path/to/your/project/storage/logs/worker.log
   stopwaitsecs=3600
   ```

4. **Set proper permissions:**
   ```bash
   chmod -R 775 storage bootstrap/cache
   chown -R www-data:www-data storage bootstrap/cache
   ```

## Troubleshooting

### Queue not processing
- Ensure queue worker is running: `php artisan queue:work`
- Check `storage/logs/laravel.log` for errors
- Verify database connection

### File upload fails
- Check file size limits in `php.ini`:
  - `upload_max_filesize`
  - `post_max_size`
- Verify `storage/app/uploads` directory exists and is writable

### Arabic text not displaying correctly
- Ensure database uses `utf8mb4` charset
- Check `config/database.php` charset settings
- Verify MySQL collation is `utf8mb4_unicode_ci`

## License

MIT

## Support

For issues or questions, please check the Laravel documentation or create an issue in the repository.

